<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Notification\NotificationTable;
use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

final class NotificationBuilder implements InterfaceNotificationSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitNotificationSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            NotificationTable::TO_USER_ID             => '',

            NotificationTable::TARGET_CONTENT_ID      => '0',

            NotificationTable::LINKED_CONTENT         => new NotificationLinkedContentDTO(),

            NotificationTable::META_TYPE              => '',
            NotificationTable::META_IS_READ           => NotificationEnum::META_IS_READ_NO,
            NotificationTable::META_IS_TRANSIENT      => NotificationEnum::META_IS_TRANSIENT_NO,

            NotificationTable::STAMP_REGISTRATION_DATE     => System::isoDate(),
            NotificationTable::STAMP_REGISTRATION          => System::isoDateTime(),
            NotificationTable::STAMP_LAST_UPDATE           => System::isoDateTime(),
        );
    }

    public function dispense(): NotificationModel
    {
        return NotificationModel::createFromData(
            array(
                // to user id

                NotificationTable::TO_USER_ID => $this -> toUserId

                ?? $this -> defaultValues[NotificationTable::TO_USER_ID],

                // target content id

                NotificationTable::TARGET_CONTENT_ID => $this -> targetContentId

                ?? $this -> defaultValues[NotificationTable::TARGET_CONTENT_ID],

                // linked content

                NotificationTable::LINKED_CONTENT => $this -> linkedContent

                ?? $this -> defaultValues[NotificationTable::LINKED_CONTENT],

                // meta type

                NotificationTable::META_TYPE => $this -> metaType

                ?? $this -> defaultValues[NotificationTable::META_TYPE],

                // meta is read

                NotificationTable::META_IS_READ => $this -> metaIsRead

                ?? $this -> defaultValues[NotificationTable::META_IS_READ],

                // meta is transient

                NotificationTable::META_IS_TRANSIENT => $this -> metaIsTransient

                ?? $this -> defaultValues[NotificationTable::META_IS_TRANSIENT],

                // stamp registration date

                NotificationTable::STAMP_REGISTRATION_DATE => $this -> stampRegistrationDate

                ?? $this -> defaultValues[NotificationTable::STAMP_REGISTRATION_DATE],

                // stamp registration

                NotificationTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[NotificationTable::STAMP_REGISTRATION],

                // stamp last update

                NotificationTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[NotificationTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
